---
title: Connection reuse and coalescing · Cloudflare Aegis docs
description: Aside from concurrent connections1, connection reuse and connection
  coalescing are also important concepts. They both have impact on latency and
  are considered when allocating your Aegis IPv4 addresses.
lastUpdated: 2025-09-17T12:18:58.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/aegis/about/reuse-and-coalescing/
  md: https://developers.cloudflare.com/aegis/about/reuse-and-coalescing/index.md
---

Aside from [concurrent connections](https://developers.cloudflare.com/aegis/about/ips-allocation/#connections-to-your-origin)[1](#user-content-fn-1), connection reuse and connection coalescing are also important concepts. They both have impact on latency and are considered when allocating your Aegis IPv4 addresses.

Implemented by HTTP/1.1, connection reuse describes multiple requests passing through one same connection (between one source IP:port and one destination IP:port). It is commonly the case even for simple websites nowadays.

For example, when a connection is initiated for `shop.example.com`, several embedded subresources may be requested - CSS, image files, advertisement, etc. This can mean hundreds of requests just for the website to load. Instead of having a one to one ratio of request per connection, a single connection is used for multiple requests.

With HTTP/2, requests can use the same connection even if they are for different domains.

For example, a connection initiated for `shop.example.com` can be used for requests for `blog.example.com` as well - as long as the requests have the same destination IP:port and the server TLS certificate is authoritative for both hostnames.

Refer to the [Cloudflare blog post](https://blog.cloudflare.com/aegis-deep-dive/) for further details.

## Footnotes

1. If you have one Aegis IP and two origins (A and B), this single Aegis IP can support 40,000 concurrent connections to origin A, while simultaneously supporting 40,000 concurrent connections to origin B. [↩](#user-content-fnref-1)
