---
title: Account and domain management best practices · Cloudflare Fundamentals docs
description: More and more of our lives revolve around our online presence and
  maintaining access to our various online accounts, such as social media,
  banking, personal, and business accounts. These accounts are critical to
  remaining connected with our loved ones and business. As such, ensuring a
  level of continuity with these services is critical. Below is a list of
  important items to help ensure you are able to maintain access or delegate
  access to your Cloudflare account in the event that you are unable to manage
  your account.
lastUpdated: 2025-07-17T15:16:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/reference/best-practices/
  md: https://developers.cloudflare.com/fundamentals/reference/best-practices/index.md
---

More and more of our lives revolve around our online presence and maintaining access to our various online accounts, such as social media, banking, personal, and business accounts. These accounts are critical to remaining connected with our loved ones and business. As such, ensuring a level of continuity with these services is critical. Below is a list of important items to help ensure you are able to maintain access or delegate access to your Cloudflare account in the event that you are unable to manage your account.

You can lose access to your account and or domain for several reasons: Death, divorce, disgruntled employee, or simply missing an email notification.

To help prevent loss of access:

* Decentralize access to your account.
* Protect yourself by following good password management practices.
* Maintain control of your domain name.
* Save your 2FA backup keys.

## Relationships, partnerships, and business ventures

Ensuring equal access with your partner, spouse, or your business partner is important to ensuring your account or domain names remain active.

If you have a domain name or a portfolio of domain names for your business, ensuring you have a strict organization policy when it comes to vendor account creation or domain name registration is critical. The steps below will ensure your organization is the owner of the account and or domain names:

* Ensure the registrant of the domain name is your organization's name.
* Ensure the vendor account is in your organization's name.
* Ensure that access to the email address used to set up these accounts is decentralized, but can still be used to send emails. Do not use a distribution list email address.

## Email addresses

If you are operating a business, use an email address that is not tied to the domain name itself, such as `john@example.com`; instead, use one of the many well known email providers as best practice. Additionally, the email address itself should be one that is shared with your business partner with a name such as `ourbusiness@example.com`. This is important because many companies require the person who is contacting them for support have access to the email address associated with the account.

## Billing information

Most if not all online services have automated billing processes that will attempt to bill the current or default credit card on file. Maintaining your billing information to avoid any payment failure is critical, as this can cause service disruptions if there is a failed billing attempt that is not resovlved in a timely manner.

## Deceased account holder or registrant

While often overlooked, an important part of having an online presence is ensuring continuity in the event of an unexpected accident or incapacitation of the account holder. Create clear instructions for domain or account management in the event the account holder is unable to administer the account. If you learn no instructions are available on how to access the account of the deceased, Cloudflare may be able to assist you.
