---
title: Configure Virtual Connector · Cloudflare Magic WAN docs
description: Learn how to configure Magic WAN Virtual Connector on VMWare ESXi
  or Proxmox Virtual Environment
lastUpdated: 2025-11-04T17:07:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/configuration/connector/configure-virtual-connector/
  md: https://developers.cloudflare.com/magic-wan/configuration/connector/configure-virtual-connector/index.md
---

Virtual Connector is a virtual device alternative to the hardware based Magic WAN Connector. These two versions of Magic WAN Connector are identical otherwise.

Currently, you can set up Virtual Connector on VMWare ESXi and Proxmox Virtual Environment. Support for Proxmox is in beta.

In this page you will find instructions on how to configure Magic WAN Connector. This guide provides a step-by-step guide for Magic WAN Connector initial setup. You can either return here after setting up your Magic WAN Connector, or refer to the [Maintenance](https://developers.cloudflare.com/magic-wan/configuration/connector/maintenance/) section where you will find instructions on how to update your settings.

## Prerequisites

Before you can install Virtual Connector, you need an Enterprise account with Magic WAN. Additionally, you need to have a VMware or Proxmox host with sufficient compute, memory, and storage to run the virtual machine with Virtual Connector. This includes:

* Intel x86 CPU architecture
* ESXi hypervisor 7.0U1 or higher
* 4 virtual CPUs per virtual connector (We recommend deployment with a 1:1 virtual CPU to physical core allocation to avoid CPU over contention which will cause packet loss.)
* 8 GB of RAM per virtual connector
* 8 GB of disk per virtual connector
* One vSwitch port group or VLAN with access to the Internet (for example, through a WAN)
* One or more vSwitch port group or VLAN that will be the internal LAN

If you are installing Virtual Connector on ESXi, refer to [VMware's documentation](https://docs.vmware.com/en/VMware-vSphere/7.0/com.vmware.esxi.install.doc/GUID-B2F01BF5-078A-4C7E-B505-5DFFED0B8C38.html) for more information on how to install ESXi and configure a virtual machine.

If you are installing Virtual Connector on Virtual Environment, refer to [Proxmox documentation](https://www.proxmox.com/en/products/proxmox-virtual-environment/get-started) for more information on how to install Virtual environment and configure a virtual machine.

***

## Before you begin

There are a couple of decisions you need to make when installing your Virtual Connector. Refer to the topics below for more information.

### Determine the need for a high availability configuration

You can install up to two instances of Virtual Connector for redundancy at each of your sites. If one of your devices fails, traffic will fail over to the other, ensuring that you never lose connectivity to that site.

In this type of high availability (HA) configuration, you will choose a reliable LAN interface as the HA link which will be used to monitor the health of the peer connector. HA links can be dedicated links or can be shared with other LAN traffic.

You must decide the type of configuration you want for your site from the beginning: no redundancy or with redundancy. You cannot add redundancy after finishing the configuration of your dashboard settings. If, at a later stage, you decide to enable redundancy, you will need to delete your Virtual Connector device in the Cloudflare dashboard, and start again.

Do you need a high availability configuration?

* If you need a high availability configuration for your premises, refer to [About high availability configurations](#about-high-availability-configurations) for more information and learn how to configure your Virtual Connector device in this mode.

* If you do not need a high availability configuration for you premises, check if you need a [DHCP or a static IP setup](#decide-on-dhcp-vs-static-ip-connections) before proceeding to [Set up Cloudflare dashboard](#set-up-cloudflare-dashboard).

Warning

You cannot enable high availability for an existing Virtual Connector on-ramp. To add high availability to an existing Virtual Connector on-ramp in the Cloudflare dashboard, you need to delete the on-ramp and start again. Plan accordingly to create a high availability configuration from the start if needed.

### Decide on DHCP vs static IP connections

Virtual Connector uses a DHCP connection at first boot to download your settings and go through the activation process. However, if you need to use a static IP in your Virtual Connector, and this is a fresh install:

1. Connect the machine with your Virtual Connector VM to a DHCP port with access to the Internet.
2. Go through the [setup flow](#set-up-cloudflare-dashboard) below and activate your Virtual Connector device.
3. Refer to [WAN with a static IP address](#wan-with-a-static-ip-address).

***

## Configure a virtual machine

Select the appropriate tab below to learn how to configure Virtual Connector on VMWare ESXi or Proxmox Virtual Environment.

* VMWare ESXi

  **1. Obtain the VMWare image**

  Contact your account team at Cloudflare to obtain the Virtual Connector OVA package and license keys. The OVA image includes the files required to install and configure the virtual machine (VM) for Virtual Connector with the appropriate settings. Refer to [VMWare VMs documentation](https://docs.vmware.com/en/VMware-vSphere/7.0/com.vmware.vsphere.vm_admin.doc/GUID-AE61948B-C2EE-436E-BAFB-3C7209088552.html) for more information on this topic.

  This image can be deployed multiple times to create several instances of a Virtual Connector, in different locations or on the same ESXi host.

  You will consume one license key for each instance created. For example, if you want to deploy 10 Virtual Connectors you should request 10 license keys, and your account team will create 10 Virtual Connector instances in your Cloudflare dashboard.

  **2. Deploy the Virtual Connector on VMware**

  The following instructions assume you already have VMware ESXi hypervisor installed with sufficient resources. Refer to [Prerequisites](#prerequisites) for more information.

  1. When setting up your VMware ESXi, you need to create port groups for Virtual Connector. Go to **Networking** > **Port groups**, and prepare your vSwitch port groups and/or VLANs for your desired network topology. For example, a simple deployment typically has:

     * A WAN port group where the Virtual Connector will get an IP address (static or DHCP) that has access to the Internet.
     * A LAN port group, where the Virtual Connector will act as default router, and possibly DHCP server.
     * A null, or unused, port group for allocating unused virtual interfaces in the Virtual Connector. You can, for example, create a null port group with the name of `Null port group`, and a **VLAN ID** of `999`.

  VLAN tagging

  Virtual Connector supports creating subinterfaces through the use of [802.1Q VLAN tagging](https://en.wikipedia.org/wiki/IEEE_802.1Q).

  Use VLAN ID `0` when:

  * Connected to a Port Group or Distributed Port Group that is associated with a specific VLAN.
  * Connected to a Port Group or Distributed Port Group that is configured as a trunk that requires untagged packets.

  You can also configure subinterfaces on the Virtual Connector by associating the network interface with a Port Group or Distributed Port Group trunk and specifying a VLAN ID in addition to the port associated with the network interface (VLAN ID `1`-`4094`).

  Refer to [VMware's documentation](https://kb.vmware.com/s/article/1003825) for more information.

  1. Extract the files in the OVA image provided by your Cloudflare account team. For example:

  ```sh
  tar -xvf mconn-2024-1-3.ova
  ```

  Take note of the folder where you are extracting the files to, as you will need to refer to that folder when creating the VM.

  1. Go to **Virtual Machines** > **Create/Register VM** wizard to start deploying the Virtual Connector.

  2. Select **Deploy a virtual machine from an OVF or OVA file** > **Next**.

  3. Choose a descriptive name for your virtual machine.

  4. Upload the files you have extracted from the OVA image. These include `mconn.ovf`, `mconn.nvram`, and `mconn.vmdk`.

  5. Select where you want to save the files extracted from the OVA image > **Next**.

  6. In **Networking mappings**, select assignments for your desired topology according to the port groups you set up previously:

     1. For example, map `eno1` port to `VM Network` to create your WAN, and `eno2` to `LAN0` to act as your LAN port.
     2. Allocate any unused ports to the `null` port group.
     3. Take note of your configuration. You will need this information to configure your network in the Cloudflare dashboard.

  7. In **Disk provisioning**, select **Thin**.

  8. Before completing the deployment wizard, disable **Power on automatically**. This is important so that you can configure the license key prior to boot.

  9. Configure the virtual machine with the license key your account team provided you:

     1. Select the Virtual Connector's VM > **Settings**.

     2. Go to **VM Options** > **Advanced** > **Edit Configuration**.

     3. Select **Add parameter** to add your license key. Scroll down to the last entry (this is where VMware adds the new parameter), and add the following two new entries:

        * **Key**: `guestinfo.cloudflare.identity`
        * **Value** `<YOUR_LICENSE_KEY>`

  Note

  You cannot use the same license key twice, or reuse a key once the virtual machine has been registered with Cloudflare. You need a new key from your account team for every new Virtual Connector.

  1. Select **Save** to finish configuring your Virtual Connector.
  2. Continue setup in your [Cloudflare dashboard.](#set-up-cloudflare-dashboard)

* Proxmox Virtual Environment (beta)

  **1. Obtain the Virtual Connector script**

  Contact your account team at Cloudflare to obtain your license keys and the Virtual Connector script for Proxmox. The script will set up and configure a Proxmox virtual machine with the appropriate settings for Virtual Connector. Refer to [Prerequisites](#prerequisites) for more information on system requirements.

  The script can be deployed multiple times to create several instances of a Virtual Connector, in different locations or on the same Proxmox host. You will consume one license key for each instance created. For example, if you want to deploy 10 Virtual Connectors you should request 10 license keys, and your account team will create 10 Virtual Connector instances in your Cloudflare dashboard.

  **2. Deploy the Virtual Connector on Proxmox**

  The following instructions assume you already have Proxmox Virtual Environment installed with sufficient resources. Refer to [Prerequisites](#prerequisites) for more information.

  1. In the terminal prompt of your Proxmox server, load the script provided by your account team. For example: `bash YOUR_SCRIPT`. You need elevated privileges to run the script.
  2. You will be prompted to create a new Virtual Connector. Select **yes** to proceed.
  3. Set up your Virtual Connector name.
  4. Enter your license key.

  Note

  You cannot use the same license key twice, or reuse a key once the virtual machine has been registered with Cloudflare. You need a new key from your account team for every new Virtual Connector.

  1. Select the network interface card (NIC) you want to use with Virtual Connector.
  2. Select the network bridge that corresponds to the physical network interface card (NIC) on your host machine. This bridge allows the network adapter in the virtual machine to communicate through the NIC in the host, as if it were directly connected to the physical network.
  3. (Optional) Configure your VLAN setting if needed.

  VLAN tagging

  Virtual Connector supports creating subinterfaces through the use of [802.1Q VLAN tagging](https://en.wikipedia.org/wiki/IEEE_802.1Q).

  Use VLAN ID `0` when:

  * Connected to a Port Group or Distributed Port Group that is associated with a specific VLAN.
  * Connected to a Port Group or Distributed Port Group that is configured as a trunk that requires untagged packets.

  You can also configure subinterfaces on the Virtual Connector by associating the network interface with a Port Group or Distributed Port Group trunk and specifying a VLAN ID in addition to the port associated with the network interface (VLAN ID `1`-`4094`).

  Refer to [Proxmox documentation](https://www.proxmox.com/en/products/proxmox-virtual-environment/get-started) for more information.

  1. Finish your configuration.
  2. The script will apply your settings and configure the virtual machine template for Virtual Connector.
  3. In the **Hardware settings** for the new VM, make sure the hardware settings match the minimum requirements for running Virtual Connector. Make changes to the RAM and CPU if needed.
  4. Continue setup in your [Cloudflare dashboard](#set-up-cloudflare-dashboard).

***

## Set up Cloudflare dashboard

### Add a Connector on-ramp

You need to add your Virtual Connector to your Cloudflare dashboard and configure its settings before connecting it to the Internet.

To add a Virtual Connector:

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/) and select your account.
2. Go to **Magic WAN** > **Connector on-ramps (beta)**.
3. Select **Add**.

1) In **Name**, enter a descriptive name for your Virtual Connector. Optionally, you can also add a description for it.

2) You need to decide if you want to turn on high availability for the Virtual Connector. Refer to [About high availability configurations](#about-high-availability-configurations) for more information.

3) Select **Create and continue**.

4) Select **Add Connector**. This will show you a list of devices associated with your account. For a Virtual Connector to show up you need to:

   * **VMWare:** Have already obtained your OVA package and license keys if you are installing on VMWare.
   * **Proxmox:** Have already obtained your Virtual Connector Script and license keys if you are installing on Proxmox.

   For more information, refer to [Configure a virtual machine](#configure-a-virtual-machine) and select the appropriate tab.

5) If you have more than one Virtual Connector, choose the one that corresponds to the on-ramp you are creating. Virtual Connector devices are identified by a serial number, also known as a service tag. Use this information to choose the right Virtual Connector.\
   Select **Add Connector** when you are ready to proceed.

6) Virtual Connector will be added to your account with an **Interrupt window** defined. The interrupt window is the time period when the Virtual Connector software can update, which may result in interruption to existing connections. You can change this later. Refer to [Interrupt window](https://developers.cloudflare.com/magic-wan/configuration/connector/maintenance/interrupt-service-window/) for more details on how to define when the Virtual Connector can update its systems.

7) Select **Continue** to proceed to creating your WAN and LAN networks.

### Create a WAN

* Dashboard

  When you have more than one anycast IP configured in your account (set up during your Magic WAN onboarding), Virtual Connector will automatically create at most two tunnels per WAN port. This improves reliability and performance, and requires no additional configuration on your part.

  1. In **WAN configuration**, select **Create**. You can create one or more [wide area networks (WANs)](https://www.cloudflare.com/learning/network-layer/what-is-a-wan/). Configuring multiple WANs will create multiple IPsec tunnels (one IPsec tunnel per WAN port). This allows Virtual Connector to load balance traffic over WANs of equal priority. It also allows Virtual Connector to failover between circuits according to their [health](https://developers.cloudflare.com/magic-wan/reference/tunnel-health-checks/). Refer to [WAN settings](https://developers.cloudflare.com/magic-wan/configuration/connector/reference/#wan-settings) for more details.

     Note

     This is not the same as a high availability (HA) configuration. HA configurations need two Virtual Connector devices to work. Refer to [About high availability configurations](#about-high-availability-configurations) for more information.

  2. In **Interface name**, enter a descriptive name for your WAN.

  3. **Interface number** needs to correspond to the virtual network interface on the Virtual Connector instance you have set up in VMware. Following our example from the previous steps, you need to choose port `1` since that is what corresponds to the `eno1` port we set up in VMware.

  4. In **VLAN ID**, enter a number between `0` and `4094` to specify a [VLAN ID](https://developers.cloudflare.com/magic-wan/configuration/connector/reference/#vlan-id).

  5. In **Priority**, choose the priority for your WAN. Lower numbers have higher priority. Refer to [Traffic steering](https://developers.cloudflare.com/magic-wan/reference/traffic-steering/) to learn more about how Cloudflare calculates priorities.

  6. In **Health check rate** configure the health check frequency for your site. Options are `low`, `mid`, and `high`. Refer to [Update tunnel health checks frequency](https://developers.cloudflare.com/magic-wan/configuration/common-settings/update-tunnel-health-checks-frequency/) for more information.

  7. **Addressing**: Select **DHCP**. This is needed the first time you set up your Virtual Connector to successfully download all settings to the machine and activate it. If you need a static IP address in your network environment:

     1. Continue the set up flow below to activate your Virtual Connector.
     2. Refer to [WAN with a static IP address](#wan-with-a-static-ip-address). If you choose a static IP, you also need to specify the static IP and gateway addresses.

  8. Select **Save** when you are finished.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  Make a `POST` request [using the API](https://developers.cloudflare.com/api/resources/magic_transit/subresources/sites/subresources/wans/methods/create/) to create a WAN.

  The `static_addressing` object is optional. Omit it if you are using DHCP. If you are using static addressing, add the `secondary_address` parameter when your site is in high availability (HA) mode.

  Example:

  ```bash
  curl https://api.cloudflare.com/client/v4/accounts/{account_id}/magic/sites/{site_id}/wans \
  --header "X-Auth-Email: <EMAIL>" \
  --header "X-Auth-Key: <API_KEY>" \
  --header "Content-Type: application/json" \
  --data '{
    "name": "<YOUR_WAN_NAME>",
    "physport": 1,
    "priority": 0,
    "vlan_tag": 0
  }'
  ```

### Create a LAN

* Dashboard

  1. In **LAN configuration**, select **Create**.

  2. Enter a descriptive name for your LAN in **Interface name**.

  3. **Interface number** needs to correspond to the virtual LAN interface on the Virtual Connector instance you have set up in VMware. Following our example from the previous steps, you need to choose port `2` since that is what corresponds to the `eno2` port we set up in VMware.

  4. In **VLAN ID**, specify a [VLAN ID](https://developers.cloudflare.com/magic-wan/configuration/connector/reference/#vlan-id) to create virtual LANs.

  5. In **Static addressing** > **Static address** give your Virtual Connector's LAN interface its IP address. You can also enable the following options if they suit your use case:

     * **This is a DHCP server**: If your Virtual Connector is a [DHCP server](https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/dhcp/dhcp-server/).
     * **This is a DHCP relay**: If your Virtual Connector is a [DHCP relay](https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/dhcp/dhcp-relay/).

  6. (Optional) In **Directly attached subnet** > **Static NAT prefix**, enter a CIDR prefix to enable NAT (network address translation). The prefix you enter here should be the same size as the prefix entered in **Static addressing**. For example, both networks have a subnet mask of `/24`: `192.168.100.0/24` and `10.10.100.0/24`.

  7. (Optional) If your LAN contains additional subnets behind a layer 3 router, select **Add routed subnet** under **Routed subnets** to add them:

     * **Prefix**: The CIDR prefix for the subnet behind the L3 router.
     * **Next hop**: The address of the L3 router to which the Virtual Connector should forward packets for this subnet.
     * **Static NAT prefix**: Optional setting. If you want to enable NAT for a routed subnet, supply an "external" prefix for the overlay-facing side of the NAT to use. It must be the same size as **Prefix**.\
       Refer to [Routed subnets](https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/routed-subnets/) for more information.

  8. Select **Save**.

  9. Select **Done** to finish your configuration. Tunnels and static routes will be automatically created for your Virtual Connector, once it boots up.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  Make a `POST` request [using the API](https://developers.cloudflare.com/api/resources/magic_transit/subresources/sites/subresources/lans/methods/create/) to create a LAN.

  Example:

  ```bash
  curl https://api.cloudflare.com/client/v4/accounts/{account_id}/magic/sites/{site_id}/lans \
  --header "X-Auth-Email: <EMAIL>" \
  --header "X-Auth-Key: <API_KEY>" \
  --header "Content-Type: application/json" \
  --data '{
    "name": "<YOUR_LAN_NAME>",
    "physport": 2,
    "static_addressing": {
      "address": "172.16.14.0/24"
    },
    "vlan_tag": 0
  }'
  ```

#### Network segmentation

After setting up your LANs, you can configure your Virtual Connector to enable communication between them without traffic leaving your premises. Refer to [Network segmentation](https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/network-segmentation/) for more information.

#### DHCP options

Virtual Connector supports different types of DHCP configurations. Virtual Connector can:

* Connect to a DHCP server or use a static IP address instead of connecting to a DHCP server.
* Act as a [DHCP server](https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/dhcp/dhcp-server/).
* Use [DHCP relay](https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/dhcp/dhcp-relay/) to connect to a DHCP server outside the location your Virtual Connector is in.
* [Reserve IP addresses](https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/dhcp/dhcp-static-address-reservation/) for specific devices on your network.

### Add your Virtual Connector to a site

After finishing your Virtual Connector configuration, you need to add it to a site.

Sites represent the local network of a data center, office, or other physical location, and combine all on-ramps available there. Sites also allow you to check, at a glance, the state of your on-ramps and set up health alert settings so that you get notified when there are issues with the site's on-ramps.

Refer to [Set up a site](https://developers.cloudflare.com/magic-wan/configuration/common-settings/sites/) for more information.

## Activate appliance

Virtual Magic WAN Connector is deactivated after you install it, and will only establish a connection to the Cloudflare network when it is activated. Cloudflare recommends leaving it deactivated until you finish [setting it up in the dashboard](#set-up-cloudflare-dashboard).

When the Virtual Connector is first activated, one of the ports must be connected to the Internet through a device that supports DHCP. This is required so that the Virtual Connector can reach the Cloudflare global network and download the required configurations that you [set up](#set-up-cloudflare-dashboard).

Warning

Remember to connect Virtual Connector through a route that supports DHCP for its first connection to the Internet. Otherwise, Virtual Connector will not work.

When you are ready to connect your Virtual Connector to the Cloudflare network:

1. In the Cloudflare dashboard, go to Magic WAN's **Configuration** page.

[Go to **Configuration**](https://dash.cloudflare.com/?to=/:account/magic-wan/configuration)

1. Go to **Connectors**.
2. Find the Virtual Connector you want to activate, select the three dots next to it > **Edit**. Make sure you verify the serial number to choose the right Virtual Connector you want to activate.
3. In the new window, the **Status** dropdown will show as **Deactivated**. Select it to change the status to **Activated**.
4. The **Interrupt window** is the time period when the Virtual Connector software can update, which may result in interruption to existing connections. Choose a time period to minimize disruption to your sites. Refer to [Interrupt window](https://developers.cloudflare.com/magic-wan/configuration/connector/maintenance/interrupt-service-window/) for more details on how to define when the Virtual Connector can update its systems.
5. Select **Update**.

## Boot your Virtual Connector

## Default password to access Virtual Connector

Your Virtual Connector's default password is the last seven characters of your license key, all uppercase, plus an `!` (exclamation mark).

For example, if your license key is `mconn-abcdefghijklmnopqrstuvwxyz`, your default password will be `TUVWXYZ!`.

***

## WAN with a static IP address

After activating your device, you can use it in a network configuration with the WAN interface set to a static IP address - that is, an Internet configuration that is not automatically set by DHCP. To use your Virtual Connector on a network configuration with a static IP, follow the steps below.

Warning

Make sure you complete the setup workflow and activate your Virtual Connector before changing the WAN settings to a static IP.

1. Connect the machine where you installed the VM with Virtual Connector to a DHCP port with access to the Internet.
2. [Add a Connector on-ramp](#add-a-connector-on-ramp) in the Cloudflare dashboard.
3. Create a [DHCP WAN](#create-a-wan).
4. [Activate](#activate-appliance) and boot your Virtual Connector.
5. Wait 60 seconds.
6. Make changes to the [WAN settings](#create-a-wan) in the Cloudflare dashboard to a static IP set up.
7. Wait 60 seconds again.
8. Modify your [Port Groups](#configure-a-virtual-machine) as needed to change the source from which the WAN port obtains its IP address.
9. Reboot your virtual machine.

***

## About high availability configurations

You need to install two Virtual Connectors before you can set up a site in high availability. When you set up a site in high availability, the WANs and LANs in your Virtual Connector have the same configuration but are replicated on two nodes. In case of failure of one of the devices, the other device becomes the active node, taking over the configuration of the LAN gateway IP and allowing traffic to continue without disruption.

Because Virtual Connectors in high availability configurations share a single site, you need to set up:

* **Static address**: The IP for the primary node in your site.
* **Secondary static address**: The IP for the secondary node in your site.
* **Virtual static address**: The IP that the LAN south of the Virtual Connector device will forward traffic to, which is the LAN's gateway IP.

Make sure all IPs are part of the same subnet.

For detailed information about the expected behavior of high availability configurations, refer to the [High availability configurations](https://developers.cloudflare.com/magic-wan/configuration/connector/reference/#high-availability-configurations) reference page.

### Create a high availability configuration

You cannot enable high availability for an existing site. To add high availability to an existing site in the Cloudflare dashboard, you need to delete the site and start again.

To set up a high availability configuration:

1. Follow the steps in [Add a Connector on-ramp](#add-a-connector-on-ramp) up until step 4.

1) After naming your site, select **Turn on high availability**.
2) Select **Create and continue**.
3) Select **Add Connector**.
4) From the list, choose your first Virtual Connector > **Add Connector**.
5) Back on the previous screen, select **Add secondary Connector**.
6) From the list, choose your second Virtual Connector > **Add Connector**.
7) Select **Continue** to create a WAN. If you are configuring a static IP, configure the IP for the primary node as the static address, and the IP for the secondary node as the secondary static address.
8) To create a LAN, follow the steps mentioned above in [Create a LAN](#create-a-lan) up until step 4.
9) In **Static address**, enter the IP for the primary node in your site. For example, `192.168.10.1/24`.
10) In **Secondary static address**, enter the IP for the secondary node in your site. For example, `192.168.10.2/24`.
11) In **Virtual static address**, enter the IP that the LAN south of the Virtual Connector device will forward traffic to. For example, `192.168.10.3/24`.
12) Select **Save**.
13) From the **High availability probing link** drop-down menu, select the port that should be used to monitor the node's health. Cloudflare recommends you choose a reliable interface as the HA probing link. The primary and secondary node's probing link should be connected over a switch, and cannot be a direct connection.
14) Follow the instructions in [Activate appliance](#activate-appliance) to finish setting up your Connectors.

***

## IPsec tunnels and static routes

Virtual Connector automatically creates [IPsec tunnels](https://developers.cloudflare.com/magic-wan/reference/gre-ipsec-tunnels/#ipsec-tunnels) and [static routes](https://developers.cloudflare.com/magic-wan/reference/traffic-steering/) for you. You cannot configure these manually.

To check the IPsec tunnels and static routes created by your Virtual Connector:

1. In the Cloudflare dashboard, go to the **Sites** page.

[Go to **Sites**](https://dash.cloudflare.com/?to=/:account/magic-wan/sites)

1. Select the name of the site for which you want to check the Virtual Connector's IPsec tunnels and static routes, and select **Edit**.
2. Select **Tunnels** to check IPsec tunnels, and **Routes** for the static routes.

***

## Next steps

* [Network options](https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/)
* [Maintenance](https://developers.cloudflare.com/magic-wan/configuration/connector/maintenance/)
* [Reference information](https://developers.cloudflare.com/magic-wan/configuration/connector/reference/)
* [Troubleshooting](https://developers.cloudflare.com/magic-wan/configuration/connector/troubleshooting/)
