---
title: Send suspect bots to a honeypot · Cloudflare Rules docs
description: Use the [bot score
  field](/workers/runtime-apis/request/#incomingrequestcfproperties) to send
  bots to a honeypot.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Redirects
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/bots-to-honeypot/
  md: https://developers.cloudflare.com/rules/snippets/examples/bots-to-honeypot/index.md
---

```js
export default {
  async fetch(request) {
    const response = await fetch(request);


    // Clone the response so that it is no longer immutable
    const newResponse = new Response(response.body, response);


    if (request.cf.botManagement.score < 30) {
      const honeypot = "https://example.com/";
      return await fetch(honeypot, request);
    } else {
      return newResponse;
    }
  },
};
```
