---
title: Error 1005 · Cloudflare Support docs
description: This error indicates that access to the website is denied due to
  the banning of the Autonomous System Number (ASN).
lastUpdated: 2025-05-14T13:30:35.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1005/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1005/index.md
---

## Errors 1005 Access Denied: Autonomous System Number (ASN) banned

This error indicates that access to the website is denied due to the banning of the Autonomous System Number (ASN).

### Common causes

The owner of the website (for example, `example.com`) has banned the autonomous system number (ASN) from accessing the website.

### Resolution

If you are not the website owner, provide the website owner with a screenshot of the 1005 error message you received.

If you are the website owner:

1. Retrieve a screenshot of the `1005` error from your customer
2. Search the [**Security Events log**](https://developers.cloudflare.com/waf/analytics/security-events/) (available at **Security** > **Events**) for the **RayID**, or client IP Address from the visitor's 1005 error message.

Note

Convert the UTC timestamp of the `1005` error to your local timezone when searching in the **Security Events log**.

1. Assess the cause of the block and ensure the ASN is allowed under the [IP Access Rules](https://developers.cloudflare.com/waf/tools/ip-access-rules/) security feature.
